(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9743,        273]*)
(*NotebookOutlinePosition[     10586,        300]*)
(*  CellTagsIndexPosition[     10542,        296]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ Example\ 2.6  .1\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(el[i_, j_] := \ 
      1/\((\((i + 1)\) \((j + 1)\))\) - 1/\((6\ \((i + 3)\) \((j + 3)\))\); \n
    m[i_, j_] := \ 1/\((i + j - 1)\); 
    \n (*\ \ For\ n = 2, \ take\ i, j = 1, 2\ *) \n
    a2 = Table[el[i, j], {i, 2}, {j, 2}]\)], "Input"],

Cell[BoxData[
    \({{23\/96, 19\/120}, {19\/120, 47\/450}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b2 = Table[m[i, j], {i, 2}, {j, 2}]\)], "Input"],

Cell[BoxData[
    \({{1, 1\/2}, {1\/2, 1\/3}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[Det[a2 - b2*mu] == 0, mu]\)], "Input"],

Cell[BoxData[
    \({{mu \[Rule] \(-0.00177245124747871685`\)}, {
        mu \[Rule] 0.313439117914145359`}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ For\ n = 3, \ take\ i, j = 1, 2, 3\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a3 = Table[el[i, j], {i, 3}, {j, 3}]\)], "Input"],

Cell[BoxData[
    \({{23\/96, 19\/120, 17\/144}, {19\/120, 47\/450, 7\/90}, {17\/144, 
        7\/90, 25\/432}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(b3 = Table[m[i, j], {i, 3}, {j, 3}]\), 
    \(NSolve[Det[a3 - b3*mu] == 0, mu]\)}], "Input"],

Cell[BoxData[
    \({{1, 1\/2, 1\/3}, {1\/2, 1\/3, 1\/4}, {1\/3, 1\/4, 1\/5}}\)], "Output"],

Cell[BoxData[
    \({{mu \[Rule] \(-0.00398635470104166742`\)}, {mu \[Rule] 0.`}, {
        mu \[Rule] 0.31356968803437506`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ For\ n = 4, \ take\ i, j = 1, 2, 3, 4\ *) \n
    a4 = Table[el[i, j], {i, 4}, {j, 4}]\), 
    \(b4 = Table[m[i, j], {i, 4}, {j, 4}]\), 
    \(NSolve[Det[a4 - b4*mu] == 0, mu]\)}], "Input"],

Cell[BoxData[
    \({{23\/96, 19\/120, 17\/144, 79\/840}, {19\/120, 47\/450, 7\/90, 
        13\/210}, {17\/144, 7\/90, 25\/432, 29\/630}, {79\/840, 13\/210, 
        29\/630, 269\/7350}}\)], "Output"],

Cell[BoxData[
    \({{1, 1\/2, 1\/3, 1\/4}, {1\/2, 1\/3, 1\/4, 1\/5}, {1\/3, 1\/4, 1\/5, 
        1\/6}, {1\/4, 1\/5, 1\/6, 1\/7}}\)], "Output"],

Cell[BoxData[
    \({{mu \[Rule] \(-0.00404958233954564761`\)}, {mu \[Rule] 0.`}, {
        mu \[Rule] 0.`}, {mu \[Rule] 0.313573391863355199`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ For\ n = 5, \ take\ i, j = 1, 2, 3, 4, 5\ *) \n
    a5 = Table[el[i, j], {i, 5}, {j, 5}]\), 
    \(b5 = Table[m[i, j], {i, 5}, {j, 5}]\), 
    \(NSolve[Det[a5 - b5*mu] == 0, mu]\)}], "Input"],

Cell[BoxData[
    \({{23\/96, 19\/120, 17\/144, 79\/840, 5\/64}, {19\/120, 47\/450, 7\/90, 
        13\/210, 37\/720}, {17\/144, 7\/90, 25\/432, 29\/630, 11\/288}, {
        79\/840, 13\/210, 29\/630, 269\/7350, 17\/560}, {5\/64, 37\/720, 
        11\/288, 17\/560, 29\/1152}}\)], "Output"],

Cell[BoxData[
    \({{1, 1\/2, 1\/3, 1\/4, 1\/5}, {1\/2, 1\/3, 1\/4, 1\/5, 1\/6}, {1\/3, 
        1\/4, 1\/5, 1\/6, 1\/7}, {1\/4, 1\/5, 1\/6, 1\/7, 1\/8}, {1\/5, 1\/6, 
        1\/7, 1\/8, 1\/9}}\)], "Output"],

Cell[BoxData[
    \({{mu \[Rule] \(-0.00404958233954564761`\)}, {mu \[Rule] 0.`}, {
        mu \[Rule] 0.`}, {mu \[Rule] 0.`}, {mu \[Rule] 0.313573391863355199`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ For\ n = 6, \ take\ i, j = 1, 2, 3, 4, 5.6\ *) \n
    a6 = Table[el[i, j], {i, 6}, {j, 6}]\), 
    \(b6 = Table[m[i, j], {i, 6}, {j, 6}]\), 
    \(NSolve[Det[a6 - b6*mu] == 0, mu]\)}], "Input"],

Cell[BoxData[
    \({{23\/96, 19\/120, 17\/144, 79\/840, 5\/64, 101\/1512}, {19\/120, 
        47\/450, 7\/90, 13\/210, 37\/720, 83\/1890}, {17\/144, 7\/90, 
        25\/432, 29\/630, 11\/288, 37\/1134}, {79\/840, 13\/210, 29\/630, 
        269\/7350, 17\/560, 7\/270}, {5\/64, 37\/720, 11\/288, 17\/560, 
        29\/1152, 65\/3024}, {101\/1512, 83\/1890, 37\/1134, 7\/270, 
        65\/3024, 437\/23814}}\)], "Output"],

Cell[BoxData[
    \({{1, 1\/2, 1\/3, 1\/4, 1\/5, 1\/6}, {1\/2, 1\/3, 1\/4, 1\/5, 1\/6, 
        1\/7}, {1\/3, 1\/4, 1\/5, 1\/6, 1\/7, 1\/8}, {1\/4, 1\/5, 1\/6, 1\/7, 
        1\/8, 1\/9}, {1\/5, 1\/6, 1\/7, 1\/8, 1\/9, 1\/10}, {1\/6, 1\/7, 
        1\/8, 1\/9, 1\/10, 1\/11}}\)], "Output"],

Cell[BoxData[
    \({{mu \[Rule] \(-0.00404958233954564761`\)}, {mu \[Rule] 0.`}, {
        mu \[Rule] 0.`}, {mu \[Rule] 0.`}, {mu \[Rule] 0.`}, {
        mu \[Rule] 0.313573391863355199`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ For\ n = 7, \ take\ i, j = 1, 2, 3, 4, 5, 6, 7\ *) \n
    a7 = Table[el[i, j], {i, 7}, {j, 7}]\), 
    \(b7 = Table[m[i, j], {i, 7}, {j, 7}]\), 
    \(NSolve[Det[a7 - b7*mu] == 0, mu]\)}], "Input"],

Cell[BoxData[
    \({{23\/96, 19\/120, 17\/144, 79\/840, 5\/64, 101\/1512, 7\/120}, {
        19\/120, 47\/450, 7\/90, 13\/210, 37\/720, 83\/1890, 23\/600}, {
        17\/144, 7\/90, 25\/432, 29\/630, 11\/288, 37\/1134, 41\/1440}, {
        79\/840, 13\/210, 29\/630, 269\/7350, 17\/560, 7\/270, 19\/840}, {
        5\/64, 37\/720, 11\/288, 17\/560, 29\/1152, 65\/3024, 3\/160}, {
        101\/1512, 83\/1890, 37\/1134, 7\/270, 65\/3024, 437\/23814, 
        121\/7560}, {7\/120, 23\/600, 41\/1440, 19\/840, 3\/160, 121\/7560, 
        67\/4800}}\)], "Output"],

Cell[BoxData[
    \({{1, 1\/2, 1\/3, 1\/4, 1\/5, 1\/6, 1\/7}, {1\/2, 1\/3, 1\/4, 1\/5, 
        1\/6, 1\/7, 1\/8}, {1\/3, 1\/4, 1\/5, 1\/6, 1\/7, 1\/8, 1\/9}, {1\/4, 
        1\/5, 1\/6, 1\/7, 1\/8, 1\/9, 1\/10}, {1\/5, 1\/6, 1\/7, 1\/8, 1\/9, 
        1\/10, 1\/11}, {1\/6, 1\/7, 1\/8, 1\/9, 1\/10, 1\/11, 1\/12}, {1\/7, 
        1\/8, 1\/9, 1\/10, 1\/11, 1\/12, 1\/13}}\)], "Output"],

Cell[BoxData[
    \({{mu \[Rule] \(-0.00404958233954564761`\)}, {mu \[Rule] 0.`}, {
        mu \[Rule] 0.`}, {mu \[Rule] 0.`}, {mu \[Rule] 0.`}, {
        mu \[Rule] 0.`}, {mu \[Rule] 0.313573391863355155`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ For\ n = 8, \ take\ i, j = 1, 2, 3, 4, 5, 6, 7, 8\ *) \n
    a8 = Table[el[i, j], {i, 8}, {j, 8}]\), 
    \(b8 = Table[m[i, j], {i, 8}, {j, 8}]\), 
    \(NSolve[Det[a8 - b8*mu] == 0, mu]\)}], "Input"],

Cell[BoxData[
    \({{23\/96, 19\/120, 17\/144, 79\/840, 5\/64, 101\/1512, 7\/120, 
        41\/792}, {19\/120, 47\/450, 7\/90, 13\/210, 37\/720, 83\/1890, 
        23\/600, 101\/2970}, {17\/144, 7\/90, 25\/432, 29\/630, 11\/288, 
        37\/1134, 41\/1440, 5\/198}, {79\/840, 13\/210, 29\/630, 269\/7350, 
        17\/560, 7\/270, 19\/840, 139\/6930}, {5\/64, 37\/720, 11\/288, 
        17\/560, 29\/1152, 65\/3024, 3\/160, 79\/4752}, {101\/1512, 83\/1890, 
        37\/1134, 7\/270, 65\/3024, 437\/23814, 121\/7560, 59\/4158}, {
        7\/120, 23\/600, 41\/1440, 19\/840, 3\/160, 121\/7560, 67\/4800, 
        49\/3960}, {41\/792, 101\/2970, 5\/198, 139\/6930, 79\/4752, 
        59\/4158, 49\/3960, 215\/19602}}\)], "Output"],

Cell[BoxData[
    \({{1, 1\/2, 1\/3, 1\/4, 1\/5, 1\/6, 1\/7, 1\/8}, {1\/2, 1\/3, 1\/4, 
        1\/5, 1\/6, 1\/7, 1\/8, 1\/9}, {1\/3, 1\/4, 1\/5, 1\/6, 1\/7, 1\/8, 
        1\/9, 1\/10}, {1\/4, 1\/5, 1\/6, 1\/7, 1\/8, 1\/9, 1\/10, 1\/11}, {
        1\/5, 1\/6, 1\/7, 1\/8, 1\/9, 1\/10, 1\/11, 1\/12}, {1\/6, 1\/7, 
        1\/8, 1\/9, 1\/10, 1\/11, 1\/12, 1\/13}, {1\/7, 1\/8, 1\/9, 1\/10, 
        1\/11, 1\/12, 1\/13, 1\/14}, {1\/8, 1\/9, 1\/10, 1\/11, 1\/12, 1\/13, 
        1\/14, 1\/15}}\)], "Output"],

Cell[BoxData[
    \({{mu \[Rule] \(-0.00404958233954564761`\)}, {mu \[Rule] 0.`}, {
        mu \[Rule] 0.`}, {mu \[Rule] 0.`}, {mu \[Rule] 0.`}, {
        mu \[Rule] 0.`}, {mu \[Rule] 0.`}, {mu \[Rule] 0.313573391863355155`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[Det[a2 - b2*mu], mu]\)], "Input"],

Cell[BoxData[
    \(LinearSolve[\(-\(1\/21600\)\) - \(187\ mu\)\/7200 + mu\^2\/12, mu]\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[Det[a3 - b3*mu], mu]\)], "Input"],

Cell[BoxData[
    \(LinearSolve[mu\/1728000 + \(743\ mu\^2\)\/5184000 - mu\^3\/2160, mu]
      \)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{4, Automatic}, {Automatic, -2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 59, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[1801, 54, 260, 5, 75, "Input"],
Cell[2064, 61, 73, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2174, 67, 68, 1, 27, "Input"],
Cell[2245, 70, 59, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2341, 76, 65, 1, 27, "Input"],
Cell[2409, 79, 122, 2, 26, "Output"]
}, Open  ]],
Cell[2546, 84, 77, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[2648, 89, 69, 1, 27, "Input"],
Cell[2720, 92, 125, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2882, 99, 113, 2, 43, "Input"],
Cell[2998, 103, 91, 1, 42, "Output"],
Cell[3092, 106, 139, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3268, 113, 214, 4, 75, "Input"],
Cell[3485, 119, 201, 3, 76, "Output"],
Cell[3689, 124, 144, 2, 76, "Output"],
Cell[3836, 128, 158, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4031, 135, 217, 4, 75, "Input"],
Cell[4251, 141, 290, 4, 110, "Output"],
Cell[4544, 147, 209, 3, 76, "Output"],
Cell[4756, 152, 183, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4976, 160, 219, 4, 75, "Input"],
Cell[5198, 166, 420, 6, 212, "Output"],
Cell[5621, 174, 289, 4, 110, "Output"],
Cell[5913, 180, 203, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6153, 188, 223, 4, 75, "Input"],
Cell[6379, 194, 560, 8, 246, "Output"],
Cell[6942, 204, 385, 5, 144, "Output"],
Cell[7330, 211, 221, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7588, 219, 226, 4, 75, "Input"],
Cell[7817, 225, 730, 10, 280, "Output"],
Cell[8550, 237, 506, 7, 246, "Output"],
Cell[9059, 246, 246, 4, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9342, 255, 65, 1, 27, "Input"],
Cell[9410, 258, 103, 2, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9550, 265, 65, 1, 27, "Input"],
Cell[9618, 268, 109, 2, 44, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

